<?php
/* --------------------------------------------------------------
   TextPhraseReader.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Repositories;

use Doctrine\DBAL\Connection;
use Gambio\Core\Language\LanguageId;

/**
 * Class TextPhraseReader
 *
 * @package Gambio\Core\Language\Repositories
 */
class TextPhraseReader
{
    /**
     * @var Connection
     */
    private $db;
    
    
    /**
     * TextPhraseReader constructor.
     *
     * @param Connection $db
     */
    public function __construct(Connection $db)
    {
        $this->db = $db;
    }
    
    
    /**
     * @param string     $section
     * @param LanguageId $languageId
     *
     * @return string[]
     */
    public function getSectionPhrases(string $section, LanguageId $languageId): array
    {
        $result = $this->db->createQueryBuilder()
            ->select('phrase_name, phrase_text')
            ->from('language_phrases_cache')
            ->where('section_name = :section')
            ->andWhere('language_id = :languageId')
            ->setParameter('section', $section)
            ->setParameter('languageId', $languageId->value())
            ->execute()
            ->fetchAll();
        
        $phrases = [];
        foreach ($result as $row) {
            $phrases[$row['phrase_name']] = $row['phrase_text'];
        }
        
        return $phrases;
    }
}